-- OpenOpcUaCoreServer.lua
-- library of callable functions
-- 	  Author
--		. Michel Condemine, 4CE Industry (2010-2023)
-- 
-- First the Autorun function executed on the OOUACoreserver Startup
-- wait for 1 second +/-
-- in fact for the time of a ping
-- need to find a better sleep function
internalStep=1;
function sleep(n)
  if n > 0 then 
	os.execute("ping -n " .. tonumber(n+1) .. " localhost > NUL") 
  end
end

function this.Autorun()
	this:SetUAValue("ns=3;i=3462", 1000) ; -- Default max Level
	this:SetUAValue("ns=3;i=3463",0); -- Pump Off
	this:SetUAValue("ns=3;i=3447",0); -- Level
end
-- FixedRate function. This function is executed at a fixed rate by the server
function this.FixedRateLua()
  level=this:GetUAValue("ns=3;i=3447",13);
  pumpState=this:GetUAValue("ns=3;i=3463",13);
  maxLevel=this:GetUAValue("ns=3;i=3462",13);  
  if (pumpState==1 and level<maxLevel) then	  
	  this:SetUAValue("ns=3;i=3447", level+internalStep) 
  end
end
function this.StartPump(this, max, step)
	this:SetUAValue("ns=3;i=3463",1);
	this:SetUAValue("ns=3;i=3462", max);
	internalStep=step;
end
function this.StopPump(this, max, step)
	this:SetUAValue("ns=3;i=3463",0);
end


-- Function Fill the Tank
function this.SetMaxLevel (this, max)
   this:SetUAValue("ns=3;i=3462", max) 
end
function this.GetCurrentLevel(this)
	x=this:GetUAValue("ns=3;i=3447",13); 
	return x;
end
-- Function Drain the Tank
function this.Drain (this)
   x=this:GetUAValue("ns=3;i=3447",13);
   while x>0 do 
       this:SetUAValue("ns=3;i=3447", x-1)
       x=this:GetUAValue("ns=3;i=3447",13) 
   end
end
-- Function Add values
function this.Add (this, nodeid, x, y)
   iRes=this:SetUAValue(nodeid, x+y);
   if (iRes>1) then 
      print("Error in function call",iRes) 
   end
   return x + y
end